/*
 * Decompiled with CFR 0.152.
 */
package asciiPanel;

import asciiPanel.AsciiCharacterData;
import asciiPanel.AsciiFont;
import asciiPanel.TileTransformer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class AsciiPanel
extends JPanel {
    private static final long serialVersionUID = -4167851861147593092L;
    public static Color black = new Color(0, 0, 0);
    public static Color red = new Color(128, 0, 0);
    public static Color green = new Color(0, 128, 0);
    public static Color yellow = new Color(128, 128, 0);
    public static Color blue = new Color(0, 0, 128);
    public static Color magenta = new Color(128, 0, 128);
    public static Color cyan = new Color(0, 128, 128);
    public static Color white = new Color(192, 192, 192);
    public static Color brightBlack = new Color(128, 128, 128);
    public static Color brightRed = new Color(255, 0, 0);
    public static Color brightGreen = new Color(0, 255, 0);
    public static Color brightYellow = new Color(255, 255, 0);
    public static Color brightBlue = new Color(0, 0, 255);
    public static Color brightMagenta = new Color(255, 0, 255);
    public static Color brightCyan = new Color(0, 255, 255);
    public static Color brightWhite = new Color(255, 255, 255);
    private Image offscreenBuffer;
    private Graphics offscreenGraphics;
    private int widthInCharacters;
    private int heightInCharacters;
    private int charWidth = 9;
    private int charHeight = 16;
    private String terminalFontFile = "cp437_9x16.png";
    private Color defaultBackgroundColor;
    private Color defaultForegroundColor;
    private int cursorX;
    private int cursorY;
    private BufferedImage glyphSprite;
    private BufferedImage[] glyphs;
    private char[][] chars;
    private Color[][] backgroundColors;
    private Color[][] foregroundColors;
    private char[][] oldChars;
    private Color[][] oldBackgroundColors;
    private Color[][] oldForegroundColors;

    public int getCharHeight() {
        return this.charHeight;
    }

    public int getCharWidth() {
        return this.charWidth;
    }

    public int getHeightInCharacters() {
        return this.heightInCharacters;
    }

    public int getWidthInCharacters() {
        return this.widthInCharacters;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public void setCursorX(int cursorX) {
        if (cursorX < 0 || cursorX >= this.widthInCharacters) {
            throw new IllegalArgumentException("cursorX " + cursorX + " must be within range [0," + this.widthInCharacters + ").");
        }
        this.cursorX = cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public void setCursorY(int cursorY) {
        if (cursorY < 0 || cursorY >= this.heightInCharacters) {
            throw new IllegalArgumentException("cursorY " + cursorY + " must be within range [0," + this.heightInCharacters + ").");
        }
        this.cursorY = cursorY;
    }

    public void setCursorPosition(int x, int y) {
        this.setCursorX(x);
        this.setCursorY(y);
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color defaultBackgroundColor) {
        if (defaultBackgroundColor == null) {
            throw new NullPointerException("defaultBackgroundColor must not be null.");
        }
        this.defaultBackgroundColor = defaultBackgroundColor;
    }

    public Color getDefaultForegroundColor() {
        return this.defaultForegroundColor;
    }

    public void setDefaultForegroundColor(Color defaultForegroundColor) {
        if (defaultForegroundColor == null) {
            throw new NullPointerException("defaultForegroundColor must not be null.");
        }
        this.defaultForegroundColor = defaultForegroundColor;
    }

    public AsciiPanel() {
        this(80, 24);
    }

    public AsciiPanel(int width, int height) {
        this(width, height, null);
    }

    public AsciiPanel(int width, int height, AsciiFont font) {
        if (width < 1) {
            throw new IllegalArgumentException("width " + width + " must be greater than 0.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height " + height + " must be greater than 0.");
        }
        if (font == null) {
            font = AsciiFont.CP437_9x16;
        }
        this.charHeight = font.getHeight();
        this.charWidth = font.getWidth();
        this.terminalFontFile = font.getFontFilename();
        this.widthInCharacters = width;
        this.heightInCharacters = height;
        this.setPreferredSize(new Dimension(this.charWidth * this.widthInCharacters, this.charHeight * this.heightInCharacters));
        this.defaultBackgroundColor = black;
        this.defaultForegroundColor = white;
        this.chars = new char[this.widthInCharacters][this.heightInCharacters];
        this.backgroundColors = new Color[this.widthInCharacters][this.heightInCharacters];
        this.foregroundColors = new Color[this.widthInCharacters][this.heightInCharacters];
        this.oldChars = new char[this.widthInCharacters][this.heightInCharacters];
        this.oldBackgroundColors = new Color[this.widthInCharacters][this.heightInCharacters];
        this.oldForegroundColors = new Color[this.widthInCharacters][this.heightInCharacters];
        this.glyphs = new BufferedImage[256];
        this.loadGlyphs();
        this.clear();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.offscreenBuffer == null) {
            this.offscreenBuffer = this.createImage(this.getWidth(), this.getHeight());
            this.offscreenGraphics = this.offscreenBuffer.getGraphics();
        }
        for (int x = 0; x < this.widthInCharacters; ++x) {
            for (int y = 0; y < this.heightInCharacters; ++y) {
                if (this.oldBackgroundColors[x][y] == this.backgroundColors[x][y] && this.oldForegroundColors[x][y] == this.foregroundColors[x][y] && this.oldChars[x][y] == this.chars[x][y]) continue;
                Color bg = this.backgroundColors[x][y];
                Color fg = this.foregroundColors[x][y];
                LookupOp op = this.setColors(bg, fg);
                BufferedImage img = op.filter(this.glyphs[this.chars[x][y]], null);
                this.offscreenGraphics.drawImage(img, x * this.charWidth, y * this.charHeight, null);
                this.oldBackgroundColors[x][y] = this.backgroundColors[x][y];
                this.oldForegroundColors[x][y] = this.foregroundColors[x][y];
                this.oldChars[x][y] = this.chars[x][y];
            }
        }
        g.drawImage(this.offscreenBuffer, 0, 0, this);
    }

    private void loadGlyphs() {
        try {
            this.glyphSprite = ImageIO.read(AsciiPanel.class.getClassLoader().getResource(this.terminalFontFile));
        }
        catch (IOException e) {
            System.err.println("loadGlyphs(): " + e.getMessage());
        }
        for (int i = 0; i < 256; ++i) {
            int sx = i % 16 * this.charWidth;
            int sy = i / 16 * this.charHeight;
            this.glyphs[i] = new BufferedImage(this.charWidth, this.charHeight, 2);
            this.glyphs[i].getGraphics().drawImage(this.glyphSprite, 0, 0, this.charWidth, this.charHeight, sx, sy, sx + this.charWidth, sy + this.charHeight, null);
        }
    }

    private LookupOp setColors(Color bgColor, Color fgColor) {
        short[] a = new short[256];
        short[] r = new short[256];
        short[] g = new short[256];
        short[] b = new short[256];
        byte bgr = (byte)bgColor.getRed();
        byte bgg = (byte)bgColor.getGreen();
        byte bgb = (byte)bgColor.getBlue();
        byte fgr = (byte)fgColor.getRed();
        byte fgg = (byte)fgColor.getGreen();
        byte fgb = (byte)fgColor.getBlue();
        for (int i = 0; i < 256; ++i) {
            if (i == 0) {
                a[i] = -1;
                r[i] = bgr;
                g[i] = bgg;
                b[i] = bgb;
                continue;
            }
            a[i] = -1;
            r[i] = fgr;
            g[i] = fgg;
            b[i] = fgb;
        }
        short[][] table = new short[][]{r, g, b, a};
        return new LookupOp(new ShortLookupTable(0, table), null);
    }

    public AsciiPanel clear() {
        return this.clear(' ', 0, 0, this.widthInCharacters, this.heightInCharacters, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel clear(char character) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        return this.clear(character, 0, 0, this.widthInCharacters, this.heightInCharacters, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel clear(char character, Color foreground, Color background) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        return this.clear(character, 0, 0, this.widthInCharacters, this.heightInCharacters, foreground, background);
    }

    public AsciiPanel clear(char character, int x, int y, int width, int height) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ").");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ").");
        }
        if (width < 1) {
            throw new IllegalArgumentException("width " + width + " must be greater than 0.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height " + height + " must be greater than 0.");
        }
        if (x + width > this.widthInCharacters) {
            throw new IllegalArgumentException("x + width " + (x + width) + " must be less than " + (this.widthInCharacters + 1) + ".");
        }
        if (y + height > this.heightInCharacters) {
            throw new IllegalArgumentException("y + height " + (y + height) + " must be less than " + (this.heightInCharacters + 1) + ".");
        }
        return this.clear(character, x, y, width, height, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel clear(char character, int x, int y, int width, int height, Color foreground, Color background) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        if (width < 1) {
            throw new IllegalArgumentException("width " + width + " must be greater than 0.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height " + height + " must be greater than 0.");
        }
        if (x + width > this.widthInCharacters) {
            throw new IllegalArgumentException("x + width " + (x + width) + " must be less than " + (this.widthInCharacters + 1) + ".");
        }
        if (y + height > this.heightInCharacters) {
            throw new IllegalArgumentException("y + height " + (y + height) + " must be less than " + (this.heightInCharacters + 1) + ".");
        }
        for (int xo = x; xo < x + width; ++xo) {
            for (int yo = y; yo < y + height; ++yo) {
                this.write(character, xo, yo, foreground, background);
            }
        }
        return this;
    }

    public AsciiPanel write(char character) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        return this.write(character, this.cursorX, this.cursorY, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel write(char character, Color foreground) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        return this.write(character, this.cursorX, this.cursorY, foreground, this.defaultBackgroundColor);
    }

    public AsciiPanel write(char character, Color foreground, Color background) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        return this.write(character, this.cursorX, this.cursorY, foreground, background);
    }

    public AsciiPanel write(char character, int x, int y) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(character, x, y, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel write(char character, int x, int y, Color foreground) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(character, x, y, foreground, this.defaultBackgroundColor);
    }

    public AsciiPanel write(char character, int x, int y, Color foreground, Color background) {
        if (character < '\u0000' || character >= this.glyphs.length) {
            throw new IllegalArgumentException("character " + character + " must be within range [0," + this.glyphs.length + "].");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        if (foreground == null) {
            foreground = this.defaultForegroundColor;
        }
        if (background == null) {
            background = this.defaultBackgroundColor;
        }
        this.chars[x][y] = character;
        this.foregroundColors[x][y] = foreground;
        this.backgroundColors[x][y] = background;
        this.cursorX = x + 1;
        this.cursorY = y;
        return this;
    }

    public AsciiPanel write(String string) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (this.cursorX + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("cursorX + string.length() " + (this.cursorX + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        return this.write(string, this.cursorX, this.cursorY, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel write(String string, Color foreground) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (this.cursorX + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("cursorX + string.length() " + (this.cursorX + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        return this.write(string, this.cursorX, this.cursorY, foreground, this.defaultBackgroundColor);
    }

    public AsciiPanel write(String string, Color foreground, Color background) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (this.cursorX + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("cursorX + string.length() " + (this.cursorX + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        return this.write(string, this.cursorX, this.cursorY, foreground, background);
    }

    public AsciiPanel write(String string, int x, int y) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (x + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("x + string.length() " + (x + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(string, x, y, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel write(String string, int x, int y, Color foreground) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (x + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("x + string.length() " + (x + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ")");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(string, x, y, foreground, this.defaultBackgroundColor);
    }

    public AsciiPanel write(String string, int x, int y, Color foreground, Color background) {
        if (string == null) {
            throw new NullPointerException("string must not be null.");
        }
        if (x + string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("x + string.length() " + (x + string.length()) + " must be less than " + this.widthInCharacters + ".");
        }
        if (x < 0 || x >= this.widthInCharacters) {
            throw new IllegalArgumentException("x " + x + " must be within range [0," + this.widthInCharacters + ").");
        }
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ").");
        }
        if (foreground == null) {
            foreground = this.defaultForegroundColor;
        }
        if (background == null) {
            background = this.defaultBackgroundColor;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i), x + i, y, foreground, background);
        }
        return this;
    }

    public AsciiPanel writeCenter(String string, int y) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("string.length() " + string.length() + " must be less than " + this.widthInCharacters + ".");
        }
        int x = (this.widthInCharacters - string.length()) / 2;
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(string, x, y, this.defaultForegroundColor, this.defaultBackgroundColor);
    }

    public AsciiPanel writeCenter(String string, int y, Color foreground) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        if (string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("string.length() " + string.length() + " must be less than " + this.widthInCharacters + ".");
        }
        int x = (this.widthInCharacters - string.length()) / 2;
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ")");
        }
        return this.write(string, x, y, foreground, this.defaultBackgroundColor);
    }

    public AsciiPanel writeCenter(String string, int y, Color foreground, Color background) {
        if (string == null) {
            throw new NullPointerException("string must not be null.");
        }
        if (string.length() >= this.widthInCharacters) {
            throw new IllegalArgumentException("string.length() " + string.length() + " must be less than " + this.widthInCharacters + ".");
        }
        int x = (this.widthInCharacters - string.length()) / 2;
        if (y < 0 || y >= this.heightInCharacters) {
            throw new IllegalArgumentException("y " + y + " must be within range [0," + this.heightInCharacters + ").");
        }
        if (foreground == null) {
            foreground = this.defaultForegroundColor;
        }
        if (background == null) {
            background = this.defaultBackgroundColor;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i), x + i, y, foreground, background);
        }
        return this;
    }

    public void withEachTile(TileTransformer transformer) {
        this.withEachTile(0, 0, this.widthInCharacters, this.heightInCharacters, transformer);
    }

    public void withEachTile(int left, int top, int width, int height, TileTransformer transformer) {
        AsciiCharacterData data = new AsciiCharacterData();
        for (int x0 = 0; x0 < width; ++x0) {
            for (int y0 = 0; y0 < height; ++y0) {
                int x = left + x0;
                int y = top + y0;
                if (x < 0 || y < 0 || x >= this.widthInCharacters || y >= this.heightInCharacters) continue;
                data.character = this.chars[x][y];
                data.foregroundColor = this.foregroundColors[x][y];
                data.backgroundColor = this.backgroundColors[x][y];
                transformer.transformTile(x, y, data);
                this.chars[x][y] = data.character;
                this.foregroundColors[x][y] = data.foregroundColor;
                this.backgroundColors[x][y] = data.backgroundColor;
            }
        }
    }
}

