/*
 * Decompiled with CFR 0.152.
 */
package nook;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import nook.CreatureAi;
import nook.Inventory;
import nook.Item;
import nook.Line;
import nook.Point;
import nook.Tile;
import nook.World;

public class Creature {
    private World world;
    public int x;
    public int y;
    public int z;
    private char glyph;
    public Color color;
    private Color defaultColor;
    private CreatureAi ai;
    private int maxHp;
    private int score;
    public int scorePts;
    private int hp;
    private int attackValue;
    private int defenseValue;
    private int visionRadius;
    private String name;
    private String description;
    private Inventory inventory;
    private int petalHealCount;

    public char glyph() {
        return this.glyph;
    }

    public Color color() {
        return this.color;
    }

    public void setCreatureAi(CreatureAi ai) {
        this.ai = ai;
    }

    public int maxHp() {
        return this.maxHp;
    }

    public int score() {
        return this.score;
    }

    public int hp() {
        return this.hp;
    }

    public int attackValue() {
        return this.attackValue;
    }

    public int defenseValue() {
        return this.defenseValue;
    }

    public int visionRadius() {
        return this.visionRadius;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Inventory inventory() {
        return this.inventory;
    }

    public void petalHealCountUp() {
        ++this.petalHealCount;
    }

    public int petalHealCount() {
        return this.petalHealCount;
    }

    public Creature(World world, String name, char glyph, Color color, int maxHp, int attack, int defense, int visionRadius, int scorePts, String description) {
        this.world = world;
        this.glyph = glyph;
        this.color = color;
        this.defaultColor = color;
        this.maxHp = maxHp;
        this.hp = maxHp;
        this.attackValue = attack;
        this.defenseValue = defense;
        this.visionRadius = visionRadius;
        this.name = name;
        this.score = 0;
        this.scorePts = scorePts;
        this.inventory = new Inventory(10);
        this.description = description;
        this.petalHealCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void moveBy(int mx, int my, int mz) {
        if (this.x + mx < 0) {
            mx = 0;
        }
        if (this.x + mx >= this.world.width()) {
            mx = this.world.width();
        }
        if (this.y + my < 0) {
            my = 0;
        }
        if (this.y + my >= this.world.height()) {
            my = this.world.height();
        }
        Tile tile = this.world.tile(this.x + mx, this.y + my, this.z + mz);
        if (mx == 0 && my == 0 && mz == 0) {
            return;
        }
        if (!tile.isWalkable()) {
            if (tile == Tile.TREE) {
                this.doAction("graze the petal tree", new Object[0]);
                return;
            }
            return;
        }
        if (tile.isWater()) {
            this.notify(Math.random() > 0.5 ? "Splish splosh!" : "Splash sploosh!", new Object[0]);
        }
        if (tile.isNookWater()) {
            this.maxHp = this.maxHp() - 2;
            this.modifyHp(this.maxHp - this.hp);
            this.notify(Math.random() > 0.5 ? "Oo! It stings." : "Ack! That sort of burns.", new Object[0]);
        }
        this.itemNotify(this.x + mx, this.y + my, this.z + mz);
        if (mz == -1) {
            if (tile != Tile.STAIRS_DOWN) {
                this.doAction("bonk your head", new Object[0]);
                return;
            }
            this.notify("You walk up to level %d", this.z + mz + 1);
        } else if (mz == 1) {
            if (tile != Tile.STAIRS_UP) {
                this.doAction("face plant", new Object[0]);
                return;
            }
            this.doAction("walk down to level %d", this.z + mz + 1);
        }
        Creature other = this.world.creature(this.x + mx, this.y + my, this.z + mz);
        if (other == null) {
            this.ai.onEnter(this.x + mx, this.y + my, this.z + mz, tile);
        } else {
            this.attack(other);
        }
        if (this.world.inNook(this.x, this.y, this.z)) {
            this.notify("Sure is cozy here.", new Object[0]);
        }
    }

    public void attack(Creature other) {
        if (other.name().equals("petal tree")) {
            if (Math.random() > 0.5) {
                this.doAction("admire the petal tree", new Object[0]);
            } else {
                this.doAction("gaze at the petal tree", new Object[0]);
            }
            return;
        }
        int amount = Math.max(0, this.attackValue() - other.defenseValue());
        amount = (int)(Math.random() * (double)amount) + 1;
        other.modifyHp(-amount);
        if (other.hp < 1) {
            this.addPoints(other);
            this.notify("The %s dies.", other.name());
        }
        this.doAction("hit the %s", other.name);
        other.notify("The %s hits you.", this.name());
    }

    public void modifyHp(int amount) {
        this.hp += amount;
        if (this.hp > this.maxHp) {
            this.hp = this.maxHp;
        }
        if (this.hp < 1) {
            if (Math.random() < 0.3) {
                this.leavePetal();
            }
            this.world.remove(this);
        }
        if (this.hp < this.maxHp / 4) {
            this.color = AsciiPanel.brightRed;
        } else if (this.hp < this.maxHp / 2) {
            this.color = AsciiPanel.brightYellow;
        } else if (this.hp > this.maxHp / 2) {
            this.color = this.defaultColor;
        }
    }

    private void leavePetal() {
        Item petal = new Item('`', AsciiPanel.green, "petal", 5, "A fungal petal.");
        this.world.addAtEmptySpace(petal, this.x, this.y, this.z);
    }

    public void addPoints(Creature other) {
        this.score += other.scorePts;
    }

    public void addPoints(int num) {
        this.score = this.score + num < 1 ? 0 : (this.score += num);
    }

    public void dig() {
        Creature player = this.creature(this.x, this.y, this.z);
        Item[] items = player.inventory().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].name().equals("petal")) continue;
            int r = 2;
            for (int ox = -r; ox < r + 1; ++ox) {
                for (int oy = -r; oy < r + 1; ++oy) {
                    if (this.world.tile(ox + this.x, oy + this.y, player.z) == null) continue;
                    this.world.dig(ox + this.x, oy + this.y, player.z);
                }
            }
            this.notify("The walls retract.", new Object[0]);
            this.notify("Your petal dissolves.", new Object[0]);
            player.inventory().remove(items[i]);
            break;
        }
    }

    public void glow() {
        Creature player = this.creature(this.x, this.y, this.z);
        int r = this.visionRadius();
        for (int ox = -r; ox < r + 1; ++ox) {
            for (int oy = -r; oy < r + 1; ++oy) {
                if (ox + this.x < 0 || ox + this.x >= this.world.width() || oy + this.y < 0 || oy + this.y >= this.world.height() || this.world.tile(ox + this.x, oy + this.y, player.z) == null) continue;
                if (ox > -3 && ox < 3 && oy > -3 && oy < 3) {
                    this.world.glow(ox + this.x, oy + this.y, player.z);
                    continue;
                }
                this.world.unglow(ox + this.x, oy + this.y, player.z);
            }
        }
    }

    public void unglow() {
        Creature player = this.creature(this.x, this.y, this.z);
        int r = this.visionRadius();
        for (int ox = -r; ox < r + 1; ++ox) {
            for (int oy = -r; oy < r + 1; ++oy) {
                if (ox + this.x < 0 || ox + this.x >= this.world.width() || oy + this.y < 0 || oy + this.y >= this.world.height() || this.world.tile(ox + this.x, oy + this.y, player.z) == null || ox <= -3 || ox >= 3 || oy <= -3 || oy >= 3) continue;
                this.world.unglow(ox + this.x, oy + this.y, player.z);
            }
        }
    }

    public void update() {
        this.ai.onUpdate();
    }

    public boolean canEnter(int wx, int wy, int wz) {
        return this.world.tile(wx, wy, wz).isGround() && this.world.creature(wx, wy, wz) == null;
    }

    public void notify(String message, Object ... params) {
        this.ai.onNotify(String.format(message, params));
    }

    public void doAction(String message, Object ... params) {
        int r = 9;
        for (int ox = -r; ox < r + 1; ++ox) {
            for (int oy = -r; oy < r + 1; ++oy) {
                Creature other;
                if (ox * ox + oy * oy > r * r || (other = this.world.creature(this.x + ox, this.y + oy, this.z)) == null || other != this) continue;
                other.notify("You " + message + ".", params);
            }
        }
    }

    private String makeSecondPerson(String text) {
        String[] words = text.split(" ");
        words[0] = words[0] + "s";
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            builder.append(" ");
            builder.append(word);
        }
        return builder.toString().trim();
    }

    public boolean canSee(int wx, int wy, int wz) {
        return this.ai.canSee(wx, wy, wz);
    }

    public boolean inNook() {
        return this.x > 27 && this.x < 34 && this.y > 11 && this.y < 17;
    }

    public void pickup() {
        Item item = this.world.item(this.x, this.y, this.z);
        if (item != null) {
            if (this.inventory.isFull()) {
                this.notify("Your pack is full.", new Object[0]);
            } else {
                this.doAction("pickup a %s", item.name());
                this.world.remove(this.x, this.y, this.z);
                this.inventory.add(item);
                this.score += item.scoreValue();
            }
        } else {
            this.notify("There's here nothing to pick up.", new Object[0]);
        }
    }

    public void drop(Item item) {
        if (item == null) {
            return;
        }
        if (this.world.addAtEmptySpace(item, this.x, this.y, this.z)) {
            this.doAction("drop a " + item.name(), new Object[0]);
            this.inventory.remove(item);
            this.score -= item.scoreValue();
        } else {
            this.notify("There's nowhere to drop the %s", item.name());
        }
    }

    private void itemNotify(int x, int y, int z) {
        Item item = this.world.item(x, y, z);
        Tile tile = this.tile(x, y, z);
        if (tile == null) {
            // empty if block
        }
        if (tile == Tile.STAIRS_UP) {
            this.notify("You see stairs leading up.", new Object[0]);
        } else if (tile == Tile.STAIRS_DOWN) {
            this.notify("You see stairs leading down.", new Object[0]);
        }
        if (item == null) {
            return;
        }
        this.notify("You see a %s here.", item.name());
    }

    public int petalCounter() {
        Item[] items = this.inventory().getItems();
        int count = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].name().equals("petal")) continue;
            ++count;
        }
        return count;
    }

    public boolean haveItem(String item) {
        Item[] items = this.inventory().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].name().equals(item)) continue;
            return true;
        }
        return false;
    }

    public Tile realTile(int wx, int wy, int wz) {
        return this.world.tile(wx, wy, wz);
    }

    public Tile tile(int wx, int wy, int wz) {
        if (this.canSee(wx, wy, wz)) {
            return this.world.tile(wx, wy, wz);
        }
        return this.ai.rememberedTile(wx, wy, wz);
    }

    public Creature creature(int wx, int wy, int wz) {
        if (this.canSee(wx, wy, wz)) {
            return this.world.creature(wx, wy, wz);
        }
        return null;
    }

    public Item item(int wx, int wy, int wz) {
        if (this.canSee(wx, wy, wz)) {
            return this.world.item(wx, wy, wz);
        }
        return null;
    }

    public void throwItem(Item item, int wx, int wy, int wz) {
        Creature c;
        Point end = new Point(this.x, this.y, 0);
        for (Point p : new Line(this.x, this.y, wx, wy)) {
            if (!this.realTile(p.x, p.y, this.z).isGround()) break;
            end = p;
        }
        if ((c = this.creature(wx = end.x, wy = end.y, wz)) != null) {
            this.throwAttack(item, c);
        }
        this.inventory.remove(item);
        this.world.addAtEmptySpace(item, wx, wy, wz);
    }

    private void throwAttack(Item item, Creature other) {
        int amount = Math.max(0, this.attackValue / 2 + item.thrownAttackValue() - other.defenseValue());
        amount = (int)(Math.random() * (double)amount) + 1;
        other.modifyHp(-amount);
    }
}

