/*
 * Decompiled with CFR 0.152.
 */
package nook;

import nook.Creature;
import nook.Line;
import nook.Point;
import nook.Tile;

public class CreatureAi {
    protected Creature creature;

    public CreatureAi(Creature creature) {
        this.creature = creature;
        this.creature.setCreatureAi(this);
    }

    public void onEnter(int x, int y, int z, Tile tile) {
        if (tile.isGround()) {
            this.creature.x = x;
            this.creature.y = y;
            this.creature.z = z;
        }
    }

    public void onUpdate() {
    }

    public void onNotify(String message) {
    }

    public Tile rememberedTile(int wx, int wy, int wz) {
        return Tile.UNKNOWN;
    }

    public boolean canSee(int wx, int wy, int wz) {
        if (this.creature.z != wz) {
            return false;
        }
        if ((this.creature.x - wx) * (this.creature.x - wx) + (this.creature.y - wy) * (this.creature.y - wy) > this.creature.visionRadius() * this.creature.visionRadius()) {
            return false;
        }
        for (Point p : new Line(this.creature.x, this.creature.y, wx, wy)) {
            if (this.creature.realTile(p.x, p.y, wz).isGround() || p.x == wx && p.y == wy) continue;
            return false;
        }
        return true;
    }
}

