/*
 * Decompiled with CFR 0.152.
 */
package nook;

import nook.Line;
import nook.Point;
import nook.Tile;
import nook.World;

public class FieldOfView {
    private World world;
    private int depth;
    private boolean[][] visible;
    private Tile[][][] tiles;

    public boolean isVisible(int x, int y, int z) {
        return z == this.depth && x >= 0 && y >= 0 && x < this.visible.length && y < this.visible[0].length && this.visible[x][y];
    }

    public Tile tile(int x, int y, int z) {
        if (x >= this.world.width() - 1) {
            x = this.world.width() - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y >= this.world.height() - 1) {
            y = this.world.height() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        return this.tiles[x][y][z];
    }

    public FieldOfView(World world) {
        this.world = world;
        this.visible = new boolean[world.width()][world.height()];
        this.tiles = new Tile[world.width()][world.height()][world.depth()];
        for (int x = 0; x < world.width(); ++x) {
            for (int y = 0; y < world.height(); ++y) {
                for (int z = 0; z < world.depth(); ++z) {
                    this.tiles[x][y][z] = Tile.UNKNOWN;
                }
            }
        }
    }

    public void update(int wx, int wy, int wz, int r) {
        this.depth = wz;
        this.visible = new boolean[this.world.width()][this.world.height()];
        for (int x = -r; x < r; ++x) {
            block1: for (int y = -r; y < r; ++y) {
                if (x * x + y * y > r * r || wx + x < 0 || wx + x >= this.world.width() || wy + y < 0 || wy + y >= this.world.height()) continue;
                for (Point p : new Line(wx, wy, wx + x, wy + y)) {
                    Tile tile = this.world.tile(p.x, p.y, wz);
                    this.visible[p.x][p.y] = true;
                    this.tiles[p.x][p.y][wz] = tile;
                    if (tile.isGround()) continue;
                    continue block1;
                }
            }
        }
    }
}

