/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.util.Random;
import nook.Creature;
import nook.CreatureAi;
import nook.StuffFactory;
import nook.Tile;

public class FungusAi
extends CreatureAi {
    private StuffFactory factory;
    private int spreadcount;
    private Random rng;
    private boolean canSpread;

    public FungusAi(Creature creature, StuffFactory factory, boolean canSpread) {
        super(creature);
        this.factory = factory;
        this.rng = new Random();
        this.canSpread = canSpread;
    }

    @Override
    public void onUpdate() {
        if (this.canSpread && this.spreadcount < 3 && Math.random() < 0.0025) {
            this.spread();
        }
    }

    private void spread() {
        int x = this.creature.x + this.rng.nextInt(3) - 1;
        int y = this.creature.y + this.rng.nextInt(3) - 1;
        Tile tile = this.creature.tile(x, y, this.creature.z);
        if (this.creature.canEnter(x, y, this.creature.z) && tile == Tile.FLOOR && !tile.isStairs()) {
            this.creature.doAction("spawn a child", new Object[0]);
            Creature child = this.factory.newFungus(this.creature.z, false);
            child.x = x;
            child.y = y;
            child.z = this.creature.z;
            ++this.spreadcount;
        }
    }
}

