/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import nook.Creature;
import nook.Point;

public class PathFinder {
    private ArrayList<Point> open = new ArrayList();
    private ArrayList<Point> closed = new ArrayList();
    private HashMap<Point, Point> parents = new HashMap();
    private HashMap<Point, Integer> totalCost = new HashMap();

    private int heuristicCost(Point from, Point to) {
        return Math.max(Math.abs(from.x - to.x), Math.abs(from.y - to.y));
    }

    private int costToGetTo(Point from) {
        return this.parents.get(from) == null ? 0 : 1 + this.costToGetTo(this.parents.get(from));
    }

    private int totalCost(Point from, Point to) {
        if (this.totalCost.containsKey(from)) {
            return this.totalCost.get(from);
        }
        int cost = this.costToGetTo(from) + this.heuristicCost(from, to);
        this.totalCost.put(from, cost);
        return cost;
    }

    private void reParent(Point child, Point parent) {
        this.parents.put(child, parent);
        this.totalCost.remove(child);
    }

    public ArrayList<Point> findPath(Creature creature, Point start, Point end, int maxTries) {
        this.open.clear();
        this.closed.clear();
        this.parents.clear();
        this.totalCost.clear();
        this.open.add(start);
        for (int tries = 0; tries < maxTries && this.open.size() > 0; ++tries) {
            Point closest = this.getClosestPoint(end);
            this.open.remove(closest);
            this.closed.add(closest);
            if (closest.equals(end)) {
                return this.createPath(start, closest);
            }
            this.checkNeighbors(creature, end, closest);
        }
        return null;
    }

    private Point getClosestPoint(Point end) {
        Point closest = this.open.get(0);
        for (Point other : this.open) {
            if (this.totalCost(other, end) >= this.totalCost(closest, end)) continue;
            closest = other;
        }
        return closest;
    }

    private void checkNeighbors(Creature creature, Point end, Point closest) {
        for (Point neighbor : closest.neighbors8()) {
            if (this.closed.contains(neighbor) || !creature.canEnter(neighbor.x, neighbor.y, creature.z) && !neighbor.equals(end)) continue;
            if (this.open.contains(neighbor)) {
                this.reParentNeighborIfNecessary(closest, neighbor);
                continue;
            }
            this.reParentNeighbor(closest, neighbor);
        }
    }

    private void reParentNeighbor(Point closest, Point neighbor) {
        this.reParent(neighbor, closest);
        this.open.add(neighbor);
    }

    private void reParentNeighborIfNecessary(Point closest, Point neighbor) {
        Point originalParent = this.parents.get(neighbor);
        double currentCost = this.costToGetTo(neighbor);
        this.reParent(neighbor, closest);
        double reparentCost = this.costToGetTo(neighbor);
        if (reparentCost < currentCost) {
            this.open.remove(neighbor);
        } else {
            this.reParent(neighbor, originalParent);
        }
    }

    private ArrayList<Point> createPath(Point start, Point end) {
        ArrayList<Point> path = new ArrayList<Point>();
        while (!end.equals(start)) {
            path.add(end);
            end = this.parents.get(end);
        }
        Collections.reverse(path);
        return path;
    }
}

