/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.util.Random;
import nook.Creature;
import nook.CreatureAi;
import nook.StuffFactory;
import nook.Tile;
import nook.World;

public class PetalTreeAi
extends CreatureAi {
    private StuffFactory factory;
    private Random rng;
    private World world;

    public PetalTreeAi(Creature creature, StuffFactory factory, World world) {
        super(creature);
        this.factory = factory;
        this.rng = new Random();
        this.world = world;
    }

    @Override
    public void onUpdate() {
        if (this.countPetalRadius() < 5 && Math.random() < 0.025) {
            this.spread();
        }
    }

    private void spread() {
        int y;
        int x = this.creature.x + this.rng.nextInt(3) - 1;
        Tile tile = this.creature.tile(x, y = this.creature.y + this.rng.nextInt(3) - 1, this.creature.z);
        if (tile.isGround() && !tile.isStairs() && this.world.item(x, y, this.creature.z) == null) {
            this.factory.newPetalDrop(x, y, this.creature.z);
        }
    }

    private int countPetalRadius() {
        int r = 2;
        int count = 0;
        int x = this.creature.x;
        int y = this.creature.y;
        int z = this.creature.z;
        for (int ox = -r; ox < r + 1; ++ox) {
            for (int oy = -r; oy < r + 1; ++oy) {
                if (ox + x < 0 || ox + x >= this.world.width() || oy + y < 0 || oy + y >= this.world.height() || this.world.item(ox + x, oy + y, z) == null || !this.world.item(ox + x, oy + y, z).name().equals("petal")) continue;
                ++count;
            }
        }
        return count;
    }
}

