/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.util.List;
import nook.Creature;
import nook.CreatureAi;
import nook.FieldOfView;
import nook.Tile;

public class PlayerAi
extends CreatureAi {
    private List<String> messages;
    private FieldOfView fov;

    public PlayerAi(Creature creature, List<String> messages, FieldOfView fov) {
        super(creature);
        this.messages = messages;
        this.fov = fov;
    }

    @Override
    public void onEnter(int x, int y, int z, Tile tile) {
        if (tile.isGround()) {
            this.creature.x = x;
            this.creature.y = y;
            this.creature.z = z;
        } else if (tile.isDiggable()) {
            this.creature.dig();
        }
    }

    @Override
    public void onNotify(String message) {
        this.messages.add(message);
    }

    @Override
    public boolean canSee(int wx, int wy, int wz) {
        return this.fov.isVisible(wx, wy, wz);
    }

    @Override
    public Tile rememberedTile(int wx, int wy, int wz) {
        return this.fov.tile(wx, wy, wz);
    }
}

