/*
 * Decompiled with CFR 0.152.
 */
package nook;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import nook.BrambleAI;
import nook.Creature;
import nook.FieldOfView;
import nook.FungusAi;
import nook.Item;
import nook.ObeliskAI;
import nook.PetalTreeAi;
import nook.PlayerAi;
import nook.SproutlingAi;
import nook.World;

public class StuffFactory {
    private World world;
    private Random rng;

    public StuffFactory(World world) {
        this.world = world;
        this.rng = new Random();
    }

    public Creature newPlayer(List<String> messages, FieldOfView fov) {
        Creature player = new Creature(this.world, "you", '\u0002', AsciiPanel.brightWhite, 25, 5, 1, 12, 10000, "This is you.");
        this.world.addAtEmptyLocation(player, 0);
        new PlayerAi(player, messages, fov);
        return player;
    }

    public Creature newFungus(int depth, boolean canSpread) {
        Creature fungus = new Creature(this.world, "fungus", '\u0005', this.colorMe(), 2, 0, 0, 2, 1, "Regular cave fungus.");
        this.world.addPlantAtEmptyLocation(fungus, depth);
        new FungusAi(fungus, this, canSpread);
        return fungus;
    }

    public Creature newSproutling(int depth, Creature player) {
        Creature sproutling = new Creature(this.world, "sproutling", '\u00ea', new Color(0, 255, 0), 10, 2, 0, 3, 10, "An erratic sproutling.");
        this.world.addAtEmptyLocation(sproutling, depth);
        new SproutlingAi(sproutling, player);
        return sproutling;
    }

    public Creature newBramble(int depth, Creature player) {
        Creature bramble = new Creature(this.world, "bramble", '\u008f', new Color(103, 175, 29), 15, 3, 1, 7, 50, "A lumbering bramble. It looks grumpy.");
        this.world.addAtEmptyLocation(bramble, depth);
        Item petal = new Item('*', new Color(9345917), "thorn", 20, "launch");
        petal.modifyThrownAttackValue(2);
        bramble.inventory().add(petal);
        new BrambleAI(bramble, player);
        return bramble;
    }

    public Creature newObelisk(int depth, Creature player) {
        Creature obelisk = new Creature(this.world, "obelisk", '8', new Color(143, 200, 63), 15, 3, 1, 9, 50, "An ominous obelisk.");
        this.world.addAroundBudlet(depth, obelisk);
        for (int i = 0; i < 10; ++i) {
            Item shard = new Item('o', new Color(133, 151, 58), "shard", 50, "An sharp fragment.");
            shard.modifyThrownAttackValue(3);
            obelisk.inventory().add(shard);
        }
        new ObeliskAI(obelisk, player);
        return obelisk;
    }

    public Creature newPetalTree(int depth) {
        Creature petalTree = new Creature(this.world, "petal tree", 'T', new Color(78, 149, 42), 10000, 0, 10000, 7, 50, "A pleasant petal tree.");
        this.world.addAtEmptyLocation(petalTree, depth);
        new PetalTreeAi(petalTree, this, this.world);
        return petalTree;
    }

    public Item newPetal(int depth) {
        Item petal = new Item('`', this.colorMe1(), "petal", 5, "Yet another lovely petal.");
        this.world.addAtEmptyLocation(petal, depth);
        return petal;
    }

    public Item newPetalDrop(int x, int y, int depth) {
        Item petalDrop = new Item('`', this.colorMe2(), "petal", 5, "A slightly smelly fungal petal.");
        this.world.addAtSpecificLocation(petalDrop, x, y, depth);
        return petalDrop;
    }

    public Item newBudlet(int depth) {
        Item budlet = new Item('\u00e8', new Color(224, 0, 219), "budlet", 4000, "A delicious bud waiting to be steeped.");
        this.world.addAtEmptyLocation(budlet, depth);
        return budlet;
    }

    public Item newSecateurs(int depth) {
        Item secateurs = new Item('\u00fb', new Color(255, 255, 255), "secateurs", 2000, "Look at this pair of pruning clippers!");
        this.world.addAtEmptyLocation(secateurs, depth);
        return secateurs;
    }

    public Item newDemitasse(int depth) {
        Item demitasse = new Item('\u00eb', new Color(255, 255, 255), "demitasse", 2000, "A minimal demitasse.");
        this.world.addAtEmptyLocation(demitasse, depth);
        return demitasse;
    }

    public Item newSaucer(int depth) {
        Item saucer = new Item('\t', new Color(255, 255, 255), "saucer", 2000, "A minimal saucer.");
        this.world.addAtEmptyLocation(saucer, depth);
        return saucer;
    }

    public Color colorMe() {
        Color[] newcolor = new Color[]{new Color(0, 100, 0), new Color(0, 255, 0), new Color(0, 160, 0)};
        return newcolor[this.rng.nextInt(3)];
    }

    public Color colorMe1() {
        Color[] newcolor = new Color[]{new Color(0, 157, 150), new Color(141, 255, 122), new Color(186, 117, 148)};
        return newcolor[this.rng.nextInt(3)];
    }

    public Color colorMe2() {
        Color[] newcolor = new Color[]{new Color(0, 255, 246), new Color(207, 255, 64), new Color(186, 117, 148)};
        return newcolor[this.rng.nextInt(3)];
    }
}

