/*
 * Decompiled with CFR 0.152.
 */
package nook;

import asciiPanel.AsciiPanel;
import java.awt.Color;

public enum Tile {
    FLOOR('.', new Color(0, 0, 0), "Walkable ground."),
    FLOOR_DUG('.', new Color(0, 64, 0), "Freshly exposed earth."),
    GRASS('\"', new Color(0, 64, 0), "Fresh squishy grass."),
    NOOK_FLOOR('.', new Color(0, 50, 0), "Your clean floor."),
    WALL('\u00db', AsciiPanel.green, "Mossy marshen wall."),
    WALL_GLOWING('\u00db', new Color(56, 220, 41), "Glowing marsh wall."),
    DEEPWALL('\u00b1', AsciiPanel.green, "Mossy marsh wall."),
    DEEPWALL_GLOWING('\u00b1', AsciiPanel.brightGreen, "Glowing marsh wall."),
    DEEPERWALL('\u00b0', AsciiPanel.green, "Mossy marsh wall."),
    DEEPERWALL_GLOWING('\u00b0', AsciiPanel.brightGreen, "Glowing marsh wall."),
    BOUNDS('#', AsciiPanel.green, "What exists beyond?"),
    NOOKWALL('\u00db', new Color(99, 200, 91), "The walls of your humble Nook."),
    DOOR('/', AsciiPanel.red, "A door."),
    STAIRS_DOWN('\u00f0', new Color(0, 74, 134), "Some stairs leading down."),
    STAIRS_UP('\u00f0', AsciiPanel.brightGreen, "Some stairs leading up"),
    WATER('~', new Color(22, 122, 195), "Crisp, fresh water."),
    NOOKWATER('~', new Color(22, 122, 195), "The Stinging Pool."),
    TREE('T', new Color(5, 83, 7), "A ancient petal tree."),
    WINDOW_VERT('|', AsciiPanel.brightWhite, "Your Nook's squeaky clean windows."),
    WINDOW_HORIZ('-', AsciiPanel.brightWhite, "Your Nook's squeaky clean windows."),
    UNKNOWN(' ', AsciiPanel.black, "(unknown)"),
    NOOK_CARPET('\u00b2', new Color(47, 64, 22), "The carpet makes the room."),
    NOOK_TABLE('\u00d2', new Color(120, 100, 44), "Your old table."),
    NOOK_CHEST('m', new Color(120, 100, 44), "Your chest."),
    NOOK_CHAIR('\u00d4', new Color(120, 100, 44), "Your favourite chair.");

    private char glyph;
    private String description;
    private Color color;
    private Color defaultColor;

    public char glyph() {
        return this.glyph;
    }

    public String description() {
        return this.description;
    }

    public Color defaultColor() {
        return this.defaultColor;
    }

    public Color color() {
        return this.color;
    }

    public Color setColor(Color color) {
        this.color = color;
        return this.color;
    }

    private Tile(char glyph, Color color, String description) {
        this.glyph = glyph;
        this.color = color;
        this.defaultColor = color;
        this.description = description;
    }

    public boolean isDiggable() {
        return this == WALL || this == DEEPWALL || this == DEEPERWALL || this == WALL_GLOWING || this == DEEPWALL_GLOWING || this == DEEPERWALL_GLOWING;
    }

    public boolean isGround() {
        return this != WALL && this != DEEPWALL && this != DEEPERWALL && this != BOUNDS && this != NOOKWALL && this != WALL_GLOWING && this != DEEPWALL_GLOWING && this != DEEPERWALL_GLOWING;
    }

    public boolean isWalkable() {
        return this != BOUNDS && this != NOOKWALL && this != WINDOW_HORIZ && this != WINDOW_VERT && this != TREE;
    }

    public boolean isNookWater() {
        return this == NOOKWATER;
    }

    public boolean isWater() {
        return this == WATER || this == NOOKWATER;
    }

    public boolean isStairs() {
        return this == STAIRS_UP || this == STAIRS_DOWN;
    }
}

