/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import nook.Creature;
import nook.Item;
import nook.Point;
import nook.Tile;

public class World {
    private Tile[][][] tiles;
    private Item[][][] items;
    private int width;
    private int height;
    private int depth;
    private List<Creature> creatures;

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int depth() {
        return this.depth;
    }

    public World(Tile[][][] tiles) {
        this.tiles = tiles;
        this.width = tiles.length;
        this.height = tiles[0].length;
        this.depth = tiles[0][0].length;
        this.creatures = new ArrayList<Creature>();
        this.items = new Item[this.width][this.height][this.depth];
    }

    public Creature creature(int x, int y, int z) {
        for (Creature c : this.creatures) {
            if (c.x != x || c.y != y || c.z != z) continue;
            return c;
        }
        return null;
    }

    public Tile tile(int x, int y, int z) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height || z < 0 || z >= this.depth) {
            return Tile.BOUNDS;
        }
        return this.tiles[x][y][z];
    }

    public char glyph(int x, int y, int z) {
        Creature creature = this.creature(x, y, z);
        if (creature != null) {
            return creature.glyph();
        }
        if (this.item(x, y, z) != null) {
            return this.item(x, y, z).glyph();
        }
        return this.tile(x, y, z).glyph();
    }

    public Color color(int x, int y, int z) {
        Creature creature = this.creature(x, y, z);
        if (creature != null) {
            return creature.color();
        }
        if (this.item(x, y, z) != null) {
            return this.item(x, y, z).color();
        }
        return this.tile(x, y, z).color();
    }

    public void dig(int x, int y, int z) {
        if (this.tile(x, y, z).isDiggable()) {
            this.tiles[x][y][z] = Tile.FLOOR_DUG;
        }
    }

    public void glow(int x, int y, int z) {
        if (this.tiles[x][y][z] == Tile.WALL) {
            this.tiles[x][y][z] = Tile.WALL_GLOWING;
        }
        if (this.tiles[x][y][z] == Tile.DEEPWALL) {
            this.tiles[x][y][z] = Tile.DEEPWALL_GLOWING;
        }
        if (this.tiles[x][y][z] == Tile.DEEPERWALL) {
            this.tiles[x][y][z] = Tile.DEEPERWALL_GLOWING;
        }
    }

    public void unglow(int x, int y, int z) {
        if (this.tiles[x][y][z] == Tile.WALL_GLOWING) {
            this.tiles[x][y][z] = Tile.WALL;
        }
        if (this.tiles[x][y][z] == Tile.DEEPWALL_GLOWING) {
            this.tiles[x][y][z] = Tile.DEEPWALL;
        }
        if (this.tiles[x][y][z] == Tile.DEEPERWALL_GLOWING) {
            this.tiles[x][y][z] = Tile.DEEPERWALL;
        }
    }

    public void addPlantAtEmptyLocation(Creature creature, int z) {
        int y;
        int x;
        while (!this.tile(x = (int)(Math.random() * (double)this.width), y = (int)(Math.random() * (double)this.height), z).isGround() || !this.tile(x, y, z).isWalkable() || this.tile(x, y, z).isWater() || this.tile(x, y, z) == Tile.NOOKWATER || this.creature(x, y, z) != null || this.tile(x, y, z).isStairs() || this.inNook(x, y, z)) {
        }
        creature.x = x;
        creature.y = y;
        creature.z = z;
        this.creatures.add(creature);
    }

    public void addAtEmptyLocation(Creature creature, int z) {
        int y;
        int x;
        while (!this.tile(x = (int)(Math.random() * (double)this.width), y = (int)(Math.random() * (double)this.height), z).isGround() || this.tile(x, y, z).isWater() || this.creature(x, y, z) != null || this.inNook(x, y, z) || this.tile(x, y, z).isStairs()) {
        }
        creature.x = x;
        creature.y = y;
        creature.z = z;
        this.creatures.add(creature);
    }

    public void addAtEmptyLocation(Item item, int depth) {
        int y;
        int x;
        while (!this.tile(x = (int)(Math.random() * (double)this.width), y = (int)(Math.random() * (double)this.height), depth).isGround() || this.creature(x, y, depth) != null || this.tile(x, y, depth).isWater() || this.item(x, y, depth) != null || this.inNook(x, y, depth) || this.tile(x, y, depth).glyph() == 'T' || this.tile(x, y, depth).isStairs() || this.tile(x, y, depth) == Tile.NOOKWATER || this.tile(x, y, depth) == Tile.WINDOW_HORIZ || this.tile(x, y, depth) == Tile.WINDOW_VERT) {
        }
        this.items[x][y][depth] = item;
    }

    public void addAtSpecificLocation(Item item, int x, int y, int depth) {
        this.items[x][y][depth] = item;
    }

    public void addAroundBudlet(int depth, Creature creature) {
        int yR;
        int xR;
        int xLoc = 0;
        int yLoc = 0;
        block0: for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 34; ++j) {
                if (this.items[i][j][depth] == null || this.item(i, j, depth).glyph() != '\u00e8') continue;
                xLoc = i;
                yLoc = j;
                continue block0;
            }
        }
        do {
            xR = ThreadLocalRandom.current().nextInt(-4, 5);
            yR = ThreadLocalRandom.current().nextInt(-4, 5);
        } while (xLoc + xR > 0 && xLoc + xR < 40 && yLoc + yR > 0 && yLoc + yR < 34 && this.items[xLoc + xR][yLoc + yR][depth] != null && this.creature(xLoc + xR, yLoc + yR, depth) != null);
        creature.x = xLoc + xR;
        creature.y = yLoc + yR;
        creature.z = depth;
        this.creatures.add(creature);
    }

    public boolean addAtEmptySpace(Item item, int x, int y, int z) {
        if (item == null) {
            return true;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        ArrayList<Point> checked = new ArrayList<Point>();
        points.add(new Point(x, y, z));
        while (!points.isEmpty()) {
            Point p = (Point)points.remove(0);
            checked.add(p);
            if (!this.tile(p.x, p.y, p.z).isGround()) continue;
            if (this.items[p.x][p.y][p.z] == null) {
                this.items[p.x][p.y][p.z] = item;
                Creature c = this.creature(p.x, p.y, p.z);
                if (c != null) {
                    c.notify("A %s lands between your feet", item.name());
                }
                return true;
            }
            List<Point> neighbors = p.neighbors8();
            neighbors.removeAll(checked);
            points.addAll(neighbors);
        }
        return false;
    }

    public void update() {
        ArrayList<Creature> toUpdate = new ArrayList<Creature>(this.creatures);
        for (Creature creature : toUpdate) {
            creature.update();
        }
    }

    public void remove(Creature other) {
        this.creatures.remove(other);
    }

    public Item item(int x, int y, int z) {
        return this.items[x][y][z];
    }

    public void remove(int x, int y, int z) {
        this.items[x][y][z] = null;
    }

    public boolean inNook(int x, int y, int z) {
        return x > 16 && x < 25 && y > 10 && y < 18 && z == 0;
    }
}

