/*
 * Decompiled with CFR 0.152.
 */
package nook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nook.Point;
import nook.Tile;
import nook.World;

public class WorldBuilder {
    private int width;
    private int height;
    private int depth;
    private Tile[][][] tiles;
    private int[][][] regions;
    private int nextRegion;

    public WorldBuilder(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.tiles = new Tile[width][height][depth];
        this.regions = new int[width][height][depth];
        this.nextRegion = 1;
    }

    public World build() {
        return new World(this.tiles);
    }

    private WorldBuilder randomizeTiles() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    this.tiles[x][y][z] = Math.random() < 0.5 ? Tile.FLOOR : Tile.WALL;
                }
            }
        }
        return this;
    }

    private WorldBuilder smooth(int times) {
        Tile[][][] tiles2 = new Tile[this.width][this.height][this.depth];
        for (int time = 0; time < times; ++time) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    for (int z = 0; z < this.depth; ++z) {
                        int floors = 0;
                        int rocks = 0;
                        for (int ox = -1; ox < 2; ++ox) {
                            for (int oy = -1; oy < 2; ++oy) {
                                if (x + ox < 0 || x + ox >= this.width || y + oy < 0 || y + oy >= this.height) continue;
                                if (this.tiles[x + ox][y + oy][z] == Tile.FLOOR) {
                                    ++floors;
                                    continue;
                                }
                                ++rocks;
                            }
                        }
                        tiles2[x][y][z] = rocks > 8 ? Tile.DEEPWALL : (floors >= rocks ? Tile.FLOOR : Tile.WALL);
                    }
                }
            }
            this.tiles = tiles2;
        }
        return this;
    }

    private WorldBuilder makeGrass() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    for (int ox = -1; ox < 2; ++ox) {
                        for (int oy = -1; oy < 2; ++oy) {
                            if (x + ox < 0 || x + ox >= this.width || y + oy < 0 || y + oy >= this.height || !this.tiles[x + ox][y + oy][z].isGround() || !(Math.random() > 0.98)) continue;
                            this.tiles[x][y][z] = Tile.GRASS;
                        }
                    }
                }
            }
        }
        return this;
    }

    private WorldBuilder createRegions() {
        this.regions = new int[this.width][this.height][this.depth];
        for (int z = 0; z < this.depth; ++z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int size;
                    if (this.tiles[x][y][z] == Tile.WALL || this.regions[x][y][z] != 0 || (size = this.fillRegion(this.nextRegion++, x, y, z)) >= 25) continue;
                    this.removeRegion(this.nextRegion - 1, z);
                }
            }
        }
        return this;
    }

    private void removeRegion(int region, int z) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.regions[x][y][z] != region) continue;
                this.regions[x][y][z] = 0;
                this.tiles[x][y][z] = Tile.WALL;
            }
        }
    }

    private int fillRegion(int region, int x, int y, int z) {
        int size = 1;
        ArrayList<Point> open = new ArrayList<Point>();
        open.add(new Point(x, y, z));
        this.regions[x][y][z] = region;
        while (!open.isEmpty()) {
            Point p = (Point)open.remove(0);
            for (Point neighbor : p.neighbors8()) {
                if (neighbor.x < 0 || neighbor.y < 0 || neighbor.x >= this.width || neighbor.y >= this.height || this.regions[neighbor.x][neighbor.y][neighbor.z] > 0 || this.tiles[neighbor.x][neighbor.y][neighbor.z] == Tile.WALL) continue;
                ++size;
                this.regions[neighbor.x][neighbor.y][neighbor.z] = region;
                open.add(neighbor);
            }
        }
        return size;
    }

    public WorldBuilder connectRegions() {
        for (int z = 0; z < this.depth - 1; ++z) {
            this.connectRegionsDown(z);
        }
        return this;
    }

    private void connectRegionsDown(int z) {
        ArrayList<String> connected = new ArrayList<String>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                String region = this.regions[x][y][z] + "," + this.regions[x][y][z + 1];
                if (this.tiles[x][y][z] != Tile.FLOOR || this.tiles[x][y][z + 1] != Tile.FLOOR || connected.contains(region) || this.tiles[x][y][z] == Tile.NOOK_FLOOR) continue;
                connected.add(region);
                this.connectRegionsDown(z, this.regions[x][y][z], this.regions[x][y][z + 1]);
            }
        }
    }

    private void connectRegionsDown(int z, int r1, int r2) {
        List<Point> candidates = this.findRegionOverlaps(z, r1, r2);
        int stairs = 0;
        do {
            Point p = candidates.remove(0);
            this.tiles[p.x][p.y][z] = Tile.STAIRS_DOWN;
            this.tiles[p.x][p.y][z + 1] = Tile.STAIRS_UP;
            ++stairs;
        } while (candidates.size() > 1400);
    }

    public List<Point> findRegionOverlaps(int z, int r1, int r2) {
        ArrayList<Point> candidates = new ArrayList<Point>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.tiles[x][y][z] != Tile.FLOOR || this.tiles[x][y][z + 1] != Tile.FLOOR || this.regions[x][y][z] != r1 || this.regions[x][y][z + 1] != r2) continue;
                candidates.add(new Point(x, y, z));
            }
        }
        Collections.shuffle(candidates);
        return candidates;
    }

    public WorldBuilder makeCaves() {
        return this.randomizeTiles().smooth(8).makeGrass().createFirstString().deepRocks().createRegions().connectRegions();
    }

    private WorldBuilder deepRocks() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    int deepRocks = 0;
                    for (int ox = -1; ox < 2; ++ox) {
                        for (int oy = -1; oy < 2; ++oy) {
                            if (x + ox < 0 || x + ox >= this.width || y + oy < 0 || y + oy >= this.height || this.tiles[x + ox][y + oy][z] != Tile.DEEPWALL && this.tiles[x + ox][y + oy][z] != Tile.DEEPERWALL) continue;
                            ++deepRocks;
                        }
                    }
                    if (deepRocks <= 7) continue;
                    this.tiles[x][y][z] = Tile.DEEPERWALL;
                }
            }
        }
        return this;
    }

    private WorldBuilder createFirstString() {
        String home = "0,,000,,,00000000000\n,,0000000000000,,,00\n00005555555555000000\n000555555555555,0000\n00,,5555555555,00000\n000,0000000000000000\n000000011---11000,00\n00000001m..h=1000,00\n0000000|.888h|0,0000\n0000000|.8<8.|0,0000\n000.000|.888.|000000\n000..001.....1000000\n00..00011-.-11000000\n0##0000000..00000000\n,##00000000..00,,,00\n,,00,,,,,,00..00,000\n000,,NNNN,,0..000000\n00,,NNNNNN,,.0000,00\n000,,NNNN,,.00000000\n0000,,,,,,0000,,0000\n00000000000000,,0000";
        String[] lines = home.split("\n");
        int i = 0;
        int j = 0;
        for (int wx = 10; wx < 30; ++wx) {
            if (i > 19) {
                i = 0;
            }
            for (int wy = 5; wy < 26; ++wy) {
                if (j > 20) {
                    j = 0;
                }
                this.tiles[wx][wy][0] = lines[j].charAt(i) == '1' ? Tile.NOOKWALL : (lines[j].charAt(i) == '5' ? Tile.WATER : (lines[j].charAt(i) == '|' ? Tile.WINDOW_VERT : (lines[j].charAt(i) == '-' ? Tile.WINDOW_HORIZ : (lines[j].charAt(i) == '#' ? Tile.WALL : (lines[j].charAt(i) == 'N' ? Tile.NOOKWATER : (lines[j].charAt(i) == '<' ? Tile.STAIRS_UP : (lines[j].charAt(i) == '.' ? Tile.NOOK_FLOOR : (lines[j].charAt(i) == ',' ? Tile.GRASS : (lines[j].charAt(i) == '8' ? Tile.NOOK_CARPET : (lines[j].charAt(i) == '=' ? Tile.NOOK_TABLE : (lines[j].charAt(i) == 'm' ? Tile.NOOK_CHEST : (lines[j].charAt(i) == 'h' ? Tile.NOOK_CHAIR : Tile.FLOOR))))))))))));
                ++j;
            }
            ++i;
        }
        return this;
    }

    private WorldBuilder addExitStairs() {
        int x = -1;
        int y = -1;
        while (this.tiles[x = (int)(Math.random() * (double)this.width)][y = (int)(Math.random() * (double)this.height)][0] != Tile.FLOOR) {
        }
        this.tiles[x][y][0] = Tile.STAIRS_UP;
        return this;
    }
}

