/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import nook.Creature;
import nook.Item;
import nook.screens.Screen;

public abstract class InventoryBasedScreen
implements Screen {
    protected Creature player;
    private String letters;

    protected abstract String getVerb();

    protected abstract boolean isAcceptable(Item var1);

    protected abstract Screen use(Item var1);

    public InventoryBasedScreen(Creature player) {
        this.player = player;
        this.letters = "abcdefghijklmnopqrstuvwxyz";
    }

    @Override
    public void displayOutput(AsciiPanel terminal) {
        ArrayList<String> lines = this.getList();
        int y = 5;
        int x = 2;
        terminal.setDefaultBackgroundColor(Color.black);
        terminal.setDefaultForegroundColor(AsciiPanel.brightWhite);
        if (lines.size() > 0) {
            terminal.clear(' ', 1, 2, 23 + this.getVerb().length() + 2, lines.size() + 4);
            for (String line : lines) {
                terminal.write(line, x, y++);
            }
            terminal.clear(' ', 1, 1, 30, 3);
            terminal.write("What would you like to " + this.getVerb() + "?", 2, 2);
        } else {
            terminal.clear(' ', 1, 1, 30, 3);
            terminal.write("You have nothing to " + this.getVerb() + ".", 2, 2);
        }
        terminal.repaint();
        terminal.setDefaultBackgroundColor(Color.black);
        terminal.setDefaultForegroundColor(AsciiPanel.brightWhite);
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        char c = key.getKeyChar();
        Item[] items = this.player.inventory().getItems();
        if (this.letters.indexOf(c) > -1 && items.length > this.letters.indexOf(c) && items[this.letters.indexOf(c)] != null && this.isAcceptable(items[this.letters.indexOf(c)])) {
            return this.use(items[this.letters.indexOf(c)]);
        }
        if (key.getKeyCode() == 27) {
            return null;
        }
        return this;
    }

    private ArrayList<String> getList() {
        ArrayList<String> lines = new ArrayList<String>();
        Item[] inventory = this.player.inventory().getItems();
        for (int i = 0; i < inventory.length; ++i) {
            Item item = inventory[i];
            if (item == null || !this.isAcceptable(item)) continue;
            String line = this.letters.charAt(i) + " - " + item.glyph() + " " + item.name();
            lines.add(line);
        }
        return lines;
    }
}

