/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import nook.Creature;
import nook.screens.PlayScreen;
import nook.screens.Screen;
import nook.screens.StartScreen;

public class LoseScreen
implements Screen {
    private int screenWidth = 40;
    private int screenHeight = 34;
    private Creature player;

    public LoseScreen(Creature player) {
        this.player = player;
    }

    @Override
    public void displayOutput(AsciiPanel terminal) {
        terminal.writeCenter("You lose.", 3);
        this.horizontalFooter(terminal, 2);
        this.horizontalFooter(terminal, 4);
        terminal.writeCenter("Number of times healed: " + this.player.petalHealCount(), 10);
        terminal.writeCenter("-- press [enter] to restart --", 35);
        terminal.writeCenter("-- press [esc] to return to title --", 36);
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        switch (key.getKeyCode()) {
            case 10: {
                return new PlayScreen();
            }
            case 27: {
                return new StartScreen();
            }
        }
        return this;
    }

    private void horizontalFooter(AsciiPanel terminal, int height) {
        for (int i = 1; i < this.screenWidth - 1; ++i) {
            terminal.write('-', i, height, Color.gray);
        }
    }
}

