/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import nook.Creature;
import nook.FieldOfView;
import nook.Item;
import nook.StuffFactory;
import nook.Tile;
import nook.World;
import nook.WorldBuilder;
import nook.screens.DropScreen;
import nook.screens.ExamineScreen;
import nook.screens.HelpScreen;
import nook.screens.LookScreen;
import nook.screens.LoseScreen;
import nook.screens.Screen;
import nook.screens.ThrowScreen;
import nook.screens.WinScreen;

public class PlayScreen
implements Screen {
    private World world;
    private Creature player;
    private int screenWidth = 40;
    private int screenHeight = 34;
    private List<String> messages;
    private FieldOfView fov;
    private Screen subscreen;
    private int playerStartX = 20;
    private int playerStartY = 14;
    private boolean haveSecateurs;
    private boolean haveBudlet;
    private boolean canSecateursBonus;
    private boolean secateurCheck;
    private boolean canWholeSetBonus;
    private boolean canSaucerBonus;
    private int counter;
    Color bg = new Color(12, 12, 12);

    public PlayScreen() {
        this.messages = new ArrayList<String>();
        this.createWorld();
        this.fov = new FieldOfView(this.world);
        StuffFactory stuffFactory = new StuffFactory(this.world);
        this.createCreatures(stuffFactory);
        this.createItems(stuffFactory);
        this.haveSecateurs = false;
        this.haveBudlet = false;
        this.canSecateursBonus = true;
        this.secateurCheck = true;
        this.canWholeSetBonus = true;
        this.counter = 0;
    }

    @Override
    public void displayOutput(AsciiPanel terminal) {
        terminal.setDefaultBackgroundColor(this.bg);
        int left = this.getScrollX();
        int top = this.getScrollY();
        this.displayTiles(terminal, left, top);
        terminal.write(this.player.glyph(), this.player.x - left, this.player.y - top, this.player.color());
        this.displayStats(terminal, 36);
        this.displayMessages(terminal, this.messages);
        if (this.subscreen != null) {
            this.subscreen.displayOutput(terminal);
        }
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        if (this.subscreen != null) {
            this.subscreen = this.subscreen.respondToUserInput(key);
        } else {
            switch (key.getKeyCode()) {
                case 27: {
                    return new LoseScreen(this.player);
                }
                case 37: 
                case 72: {
                    this.player.moveBy(-1, 0, 0);
                    break;
                }
                case 39: 
                case 76: {
                    this.player.moveBy(1, 0, 0);
                    break;
                }
                case 38: 
                case 75: {
                    this.player.moveBy(0, -1, 0);
                    break;
                }
                case 40: 
                case 74: {
                    this.player.moveBy(0, 1, 0);
                    break;
                }
                case 89: {
                    this.player.moveBy(-1, -1, 0);
                    break;
                }
                case 85: {
                    this.player.moveBy(1, -1, 0);
                    break;
                }
                case 66: {
                    this.player.moveBy(-1, 1, 0);
                    break;
                }
                case 78: {
                    this.player.moveBy(1, 1, 0);
                    break;
                }
                case 68: {
                    if (this.player.inventory().isEmpty()) {
                        this.player.notify("You have nothing to drop.", new Object[0]);
                        break;
                    }
                    this.subscreen = new DropScreen(this.player);
                    break;
                }
                case 80: {
                    this.petalHealer();
                    break;
                }
                case 73: {
                    this.subscreen = new ExamineScreen(this.player);
                    break;
                }
                case 59: {
                    this.subscreen = new LookScreen(this.world, this.player, "Looking around.", this.player.x - this.getScrollX(), this.player.y - this.getScrollY());
                    break;
                }
                case 84: {
                    this.subscreen = new ThrowScreen(this.world, this.player, this.player.x - this.getScrollX(), this.player.y - this.getScrollY());
                }
            }
            switch (key.getKeyChar()) {
                case ',': 
                case 'g': {
                    this.player.pickup();
                    break;
                }
                case '<': {
                    if (this.userIsTryingToExit()) {
                        return this.userExits();
                    }
                    this.player.moveBy(0, 0, -1);
                    break;
                }
                case '>': {
                    this.player.moveBy(0, 0, 1);
                    break;
                }
                case '?': {
                    this.subscreen = new HelpScreen();
                }
            }
        }
        if (this.subscreen == null) {
            this.world.update();
        }
        if (this.player.hp() < 1) {
            return new LoseScreen(this.player);
        }
        ++this.counter;
        this.scoreChecker();
        return this;
    }

    private void createCreatures(StuffFactory stuffFactory) {
        int i;
        int z;
        this.player = stuffFactory.newPlayer(this.messages, this.fov);
        this.player.x = this.playerStartX;
        this.player.y = this.playerStartY;
        for (z = 0; z < this.world.depth(); ++z) {
            for (i = 0; i < 12; ++i) {
                stuffFactory.newFungus(z, true);
            }
        }
        for (z = 1; z < this.world.depth(); ++z) {
            for (i = 0; i < 6; ++i) {
                stuffFactory.newSproutling(z, this.player);
            }
        }
        for (z = 3; z < this.world.depth(); ++z) {
            for (i = 0; i < 5; ++i) {
                stuffFactory.newBramble(z, this.player);
            }
        }
        for (z = 0; z < this.world.depth(); ++z) {
            for (i = 0; i < 4; ++i) {
                stuffFactory.newPetalTree(z);
            }
        }
        stuffFactory.newBudlet(4);
        for (int i2 = 0; i2 < 2; ++i2) {
            stuffFactory.newObelisk(4, this.player);
        }
    }

    private void createItems(StuffFactory stuffFactory) {
        for (int z = 0; z < this.world.depth(); ++z) {
            for (int i = 0; i < this.world.width() * this.world.height() / 100; ++i) {
                stuffFactory.newPetal(z);
            }
        }
        stuffFactory.newSecateurs(this.world.depth() - 2);
        stuffFactory.newDemitasse(this.world.depth() - 4);
        stuffFactory.newSaucer(this.world.depth() - 3);
    }

    private void createWorld() {
        this.world = new WorldBuilder(40, 34, 5).makeCaves().build();
    }

    public int getScrollX() {
        return Math.max(0, Math.min(this.player.x - this.screenWidth / 2, this.world.width() - this.screenWidth));
    }

    public int getScrollY() {
        return Math.max(0, Math.min(this.player.y - this.screenHeight / 2, this.world.height() - this.screenHeight));
    }

    private void displayStats(AsciiPanel terminal, int y) {
        terminal.clear(' ', 0, 34, 40, 6, AsciiPanel.brightWhite, this.bg);
        String depthNumber = this.player.z == 0 ? String.format("[Nook]", new Object[0]) : String.format("[Cave depth: %1d]", this.player.z + 1);
        String scoreStats = String.format("%1d pts", this.player.score());
        String hpStats = String.format("%1d/%1dHP", this.player.hp(), this.player.maxHp());
        String petalCount = String.format("%1d/10 [p]etals", this.player.petalCounter());
        terminal.writeCenter(depthNumber, y - 1, null, this.bg);
        terminal.writeCenter(hpStats, y, null, this.bg);
        if (this.player.petalCounter() >= 10) {
            terminal.writeCenter(petalCount, y + 1, Color.green, this.bg);
        } else if (this.player.petalCounter() >= 5) {
            terminal.writeCenter(petalCount, y + 1, Color.blue, this.bg);
        } else {
            terminal.writeCenter(petalCount, y + 1, null, this.bg);
        }
        terminal.writeCenter(scoreStats, y + 2, null, this.bg);
    }

    private void displayMessages(AsciiPanel terminal, List<String> messages) {
        int a = 255;
        int top = this.player.y < 11 ? this.screenHeight - 2 - messages.size() : 5 - messages.size();
        for (int i = 0; i < messages.size(); ++i) {
            Color col = new Color(a, a, a);
            terminal.writeCenter(messages.get(i), top + i, col);
            if ((a -= 75) >= 0) continue;
            a = 0;
        }
        messages.clear();
    }

    private void displayTiles(AsciiPanel terminal, int left, int top) {
        this.fov.update(this.player.x, this.player.y, this.player.z, this.player.visionRadius());
        for (int x = 0; x < this.screenWidth; ++x) {
            for (int y = 0; y < this.screenHeight; ++y) {
                int wx = x + left;
                int wy = y + top;
                if (this.player.canSee(wx, wy, this.player.z)) {
                    terminal.write(this.world.glyph(wx, wy, this.player.z), x, y, this.world.color(wx, wy, this.player.z), new Color(0, 30, 0));
                    if (this.player.haveItem("petal")) {
                        this.player.glow();
                        continue;
                    }
                    this.player.unglow();
                    continue;
                }
                terminal.write(this.fov.tile(wx, wy, this.player.z).glyph(), x, y, new Color(11, 36, 10));
            }
        }
        terminal.setDefaultBackgroundColor(Color.black);
        terminal.setDefaultForegroundColor(Color.white);
    }

    private boolean userIsTryingToExit() {
        return this.player.z == 0 && this.world.tile(this.player.x, this.player.y, this.player.z) == Tile.STAIRS_UP;
    }

    private Screen userExits() {
        for (Item item : this.player.inventory().getItems()) {
            if (item == null || !item.name().equals("budlet")) continue;
            return new WinScreen(this.player);
        }
        return new LoseScreen(this.player);
    }

    private void petalHealer() {
        Item[] items = this.player.inventory().getItems();
        if (this.player.petalCounter() >= 5) {
            this.player.modifyHp(5 + (this.player.maxHp() - this.player.hp()) / 10);
            int rem = 0;
            for (int i = 0; i < items.length; ++i) {
                if (rem >= 5 || items[i] == null || !items[i].name().equals("petal")) continue;
                this.player.inventory().remove(items[i]);
                ++rem;
            }
            this.player.petalHealCountUp();
        }
    }

    private void scoreChecker() {
        if (this.player.haveItem("budlet") && !this.player.haveItem("secateurs")) {
            this.canSecateursBonus = false;
        }
        if (this.player.haveItem("demitasse") && !this.player.haveItem("saucer")) {
            this.canSaucerBonus = false;
        }
        if (this.player.haveItem("secateurs") && this.player.haveItem("budlet") && this.canSecateursBonus) {
            this.player.notify("You snip off the budlet.", new Object[0]);
            this.player.addPoints(4000);
            this.canSecateursBonus = false;
        }
        if (this.canWholeSetBonus && this.player.haveItem("secateurs") && this.player.haveItem("budlet") && this.player.haveItem("demitasse") && this.player.haveItem("saucer")) {
            this.player.addPoints(this.player.score());
            this.canWholeSetBonus = false;
        }
        if (this.counter % 3 == 0) {
            this.player.addPoints(-1);
        }
    }
}

