/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import nook.screens.HelpScreen;
import nook.screens.PlayScreen;
import nook.screens.Screen;

public class StartScreen
implements Screen {
    private Screen subscreen;

    @Override
    public void displayOutput(AsciiPanel terminal) {
        this.horizontalFooter(terminal, 12);
        this.horizontalFooter(terminal, 16);
        terminal.writeCenter("\u0005 NOOK \u0005", 14, AsciiPanel.brightGreen);
        terminal.writeCenter("Start [enter]", 20, AsciiPanel.brightWhite);
        terminal.writeCenter("How to Play [?]", 22, AsciiPanel.brightWhite);
        terminal.writeCenter("Quit [escape]", 24, AsciiPanel.brightWhite);
        terminal.writeCenter("v.0.1.2", 28);
        if (this.subscreen != null) {
            this.subscreen.displayOutput(terminal);
        }
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        if (this.subscreen != null) {
            this.subscreen = this.subscreen.respondToUserInput(key);
        } else {
            switch (key.getKeyCode()) {
                case 27: {
                    System.exit(0);
                }
                case 10: {
                    return new PlayScreen();
                }
            }
        }
        switch (key.getKeyChar()) {
            case '?': {
                this.subscreen = new HelpScreen();
            }
        }
        return this;
    }

    private void horizontalFooter(AsciiPanel terminal, int height) {
        for (int i = 12; i < 27; ++i) {
            terminal.write('-', i, height, Color.gray);
        }
    }
}

