/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import nook.Creature;
import nook.Line;
import nook.Point;
import nook.World;
import nook.screens.Screen;

public abstract class TargetBasedScreen
implements Screen {
    protected Creature player;
    protected String caption;
    private World world;
    private int sx;
    private int sy;
    private int x;
    private int y;

    public TargetBasedScreen(World world, Creature player, String caption, int sx, int sy) {
        this.player = player;
        this.caption = caption;
        this.sx = sx;
        this.sy = sy;
        this.world = world;
    }

    @Override
    public void displayOutput(AsciiPanel terminal) {
        terminal.clear(' ', 0, 34, 40, 6, AsciiPanel.brightWhite, new Color(12, 12, 12));
        for (Point p : new Line(this.sx, this.sy, this.sx + this.x, this.sy + this.y)) {
            if (this.sx + this.x < 0 || this.sx + this.x > this.world.width() - 1 || this.sy + this.y < 0 || this.sy + this.y > this.world.height() - 1) continue;
            char curr = this.player.canSee(this.sx + this.x, this.sy + this.y, this.player.z) ? (char)this.world.glyph(this.sx + this.x, this.sy + this.y, this.player.z) : (char)' ';
            terminal.write('*', p.x, p.y, AsciiPanel.brightGreen);
            terminal.write(this.player.glyph(), this.sx, this.sy);
            terminal.write(curr, this.sx + this.x, this.sy + this.y, AsciiPanel.black, AsciiPanel.brightGreen);
        }
        terminal.clear(' ', 0, 37, 40, 1);
        if (this.sy + this.y < 11) {
            terminal.writeCenter(this.caption, 31);
        } else {
            terminal.writeCenter(this.caption, 5);
        }
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        int prevX = this.x--;
        int prevY = this.y--;
        switch (key.getKeyCode()) {
            case 37: 
            case 72: {
                break;
            }
            case 39: 
            case 76: {
                ++this.x;
                break;
            }
            case 38: 
            case 74: {
                break;
            }
            case 40: 
            case 75: {
                ++this.y;
                break;
            }
            case 89: {
                --this.x;
                --this.y;
                break;
            }
            case 85: {
                ++this.x;
                --this.y;
                break;
            }
            case 66: {
                --this.x;
                ++this.y;
                break;
            }
            case 78: {
                ++this.x;
                ++this.y;
                break;
            }
            case 10: {
                this.selectWorldCoordinate(this.player.x + this.x, this.player.y + this.y, this.sx + this.x, this.sy + this.y);
                return null;
            }
            case 27: {
                return null;
            }
        }
        this.enterWorldCoordinate(this.player.x + this.x, this.player.y + this.y, this.sx + this.x, this.sy + this.y);
        if (this.sx + this.x > this.world.width() - 1 || this.sx + this.x < 0) {
            this.x = prevX;
        }
        if (this.sy + this.y > this.world.height() - 1 || this.sy + this.y < 0) {
            this.y = prevY;
        }
        return this;
    }

    public boolean isAcceptable(int x, int y) {
        return true;
    }

    public void enterWorldCoordinate(int x, int y, int screenX, int screenY) {
    }

    public void selectWorldCoordinate(int x, int y, int screenX, int screenY) {
    }
}

