/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import nook.Creature;
import nook.Item;
import nook.Line;
import nook.Point;
import nook.World;
import nook.screens.TargetBasedScreen;

public class ThrowAtScreen
extends TargetBasedScreen {
    private Item item;
    private World world;

    public ThrowAtScreen(World world, Creature player, int sx, int sy, Item item) {
        super(world, player, "Throw " + item.name() + " at?", sx, sy);
        this.item = item;
    }

    @Override
    public boolean isAcceptable(int x, int y) {
        if (!this.player.canSee(x, y, this.player.z)) {
            return false;
        }
        for (Point p : new Line(this.player.x, this.player.y, x, y)) {
            if (this.player.realTile(p.x, p.y, this.player.z).isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void selectWorldCoordinate(int x, int y, int screenX, int screenY) {
        this.player.throwItem(this.item, x, y, this.player.z);
    }
}

