/*
 * Decompiled with CFR 0.152.
 */
package nook.screens;

import asciiPanel.AsciiPanel;
import java.awt.Color;
import java.awt.event.KeyEvent;
import nook.Creature;
import nook.screens.PlayScreen;
import nook.screens.Screen;
import nook.screens.StartScreen;

public class WinScreen
implements Screen {
    private int screenWidth;
    private int screenHeight;
    private Creature player;
    int petalHealCount;

    public WinScreen(Creature player) {
        this.player = player;
        this.screenWidth = 40;
        this.screenHeight = 34;
    }

    @Override
    public void displayOutput(AsciiPanel terminal) {
        terminal.writeCenter("You won!", 3);
        this.horizontalFooter(terminal, 2);
        this.horizontalFooter(terminal, 4);
        terminal.writeCenter("You safely return to your nook", 12);
        terminal.writeCenter("with a freshly picked budlet.", 13);
        terminal.writeCenter("Number of times healed: " + this.player.petalHealCount(), 15);
        terminal.writeCenter("Your final score: " + this.player.score(), 17, AsciiPanel.brightGreen);
        terminal.writeCenter("-- press [enter] to restart --", 35);
        terminal.writeCenter("-- press [esc] to return to title --", 36);
    }

    @Override
    public Screen respondToUserInput(KeyEvent key) {
        switch (key.getKeyCode()) {
            case 10: {
                return new PlayScreen();
            }
            case 27: {
                return new StartScreen();
            }
        }
        return this;
    }

    private void horizontalFooter(AsciiPanel terminal, int height) {
        for (int i = 1; i < this.screenWidth - 1; ++i) {
            terminal.write('-', i, height, Color.gray);
        }
    }
}

